function spectra_l1_vdotb, phase_start, thetab_, phib_, bvalid, $
                           mode=mode, rele=rele_in, rion=rion_in, $
                           cdfcal=CAL, init=init
;  returns the pitch angles for a given block

  common spectra_l1_vdotb_common, theta_ele, phi_ele, $
    sin_theta, phi_ion, $
    phi_offset, rele, rion

  if keyword_set( init ) then begin
      hyd_cdf_varget, CAL, 'THETA_ELE_RP', theta_ele ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_ELE_RP', phi_ele ; fltarr(12)
      hyd_cdf_varget, CAL, 'THETA_ION_RP', theta_ion ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_ION_RP', phi_ion ; fltarr(12)
      hyd_cdf_varget, CAL, 'PHI_OFFSET', phi_offset, rec_start= mode-1 ;fltarr(384)
      rele= rele_in
      rion= rion_in

      return, -1
      
  endif else begin
      r= indgen(384)*2+1
      phib= ( phib_(r) + 0.5 ) * 2 * !pi / 256 
      thetab= (thetab_(r) + 0.5 ) * 2 * !pi / 256

      pitch= fltarr( 384, 12 )

      r= where( bvalid eq 0 )
      if r(0) eq -1 then begin
          sin_thetab= sin(thetab)
          bhat=[[sin_thetab*cos(phib)], [sin_thetab*sin(phib)], [cos(thetab)] ]
          
          phidet= fltarr( 384 )
          dethat= fltarr( 384, 3 )
          theta= fltarr(384)
          for idet=0,11 do begin
              phidet(rele)= phi_ele(idet) 
              phidet(rion)= phi_ion(idet) 
              theta(rele)= theta_ele(idet)
              theta(rion)= theta_ion(idet)
              sin_theta= sin( theta )
              dethat(*,0)= sin_theta * cos( phidet )
              dethat(*,1)= sin_theta * sin( phidet )
              dethat(*,2)= cos( theta )
              
              pitch(*,idet)= total((bhat*dethat),2)     
          endfor   
          
          pitch=acos(pitch)

      endif else begin
          pitch(*)=1e20
      endelse
  endelse

  return, pitch
end
